# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-24.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24309);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-24");
 script_cve_id("CVE-2007-0017");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-24
(VLC media player: Format string vulnerability)


    Kevin Finisterre has discovered that when handling media locations,
    various functions throughout VLC media player make improper use of
    format strings.
  
Impact

    An attacker could entice a user to open a specially crafted media
    location or M3U file with VLC media player, and execute arbitrary code
    on the system with the rights of the user running VLC media player.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0017


Solution: 
    All VLC media player users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-video/vlc-0.8.6-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-24] VLC media player: Format string vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'VLC media player: Format string vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-video/vlc", unaffected: make_list("ge 0.8.6-r1"), vulnerable: make_list("lt 0.8.6-r1")
)) { security_warning(0); exit(0); }
