# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24310);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-25");
 script_cve_id("CVE-2006-6101", "CVE-2006-6102", "CVE-2006-6103");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-25
(X.Org X server: Multiple vulnerabilities)


    Multiple memory corruption vulnerabilities have been found in the
    ProcDbeGetVisualInfo() and the ProcDbeSwapBuffers() of the DBE
    extension, and ProcRenderAddGlyphs() in the Render extension.
  
Impact

    A local attacker could execute arbitrary code with the privileges of
    the user running the X server, typically root.
  
Workaround

    Disable the dbe and render extension by removing the "Load dbe" and
    "Load render" directives in the Module section of xorg.conf.
    Note: This could affect the functionality of some applications.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6101
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6102
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6103


Solution: 
    All X.Org X server users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-base/xorg-server-1.1.1-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-25] X.Org X server: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'X.Org X server: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-base/xorg-server", unaffected: make_list("ge 1.1.1-r4"), vulnerable: make_list("lt 1.1.1-r4")
)) { security_warning(0); exit(0); }
