# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-26.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24311);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-26");
 script_cve_id("CVE-2006-6811");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-26
(KSirc: Denial of Service vulnerability)


    KSirc fails to check the size of an incoming PRIVMSG string sent from
    an IRC server during the connection process.
  
Impact

    A malicious IRC server could send a long PRIVMSG string to the KSirc
    client causing an assertion failure and the dereferencing of a null
    pointer, resulting in a crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6811


Solution: 
    All KSirc users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=kde-base/ksirc-3.5.5-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-26] KSirc: Denial of Service vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'KSirc: Denial of Service vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "kde-base/ksirc", unaffected: make_list("ge 3.5.5-r1"), vulnerable: make_list("lt 3.5.5-r1")
)) { security_warning(0); exit(0); }
