# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24350);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200702-01");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-01
(Samba: Multiple vulnerabilities)


    A format string vulnerability exists in the VFS module when handling
    AFS file systems and an infinite loop has been discovered when handling
    file rename operations.
  
Impact

    A user with permission to write to a shared AFS file system may be able
    to compromise the smbd process and execute arbitrary code with the
    permissions of the daemon. The infinite loop could be abused to consume
    excessive resources on the smbd host, denying service to legitimate
    users.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://samba.org/samba/security/CVE-2007-0452.html
    http://samba.org/samba/security/CVE-2007-0454.html


Solution: 
    All Samba users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-fs/samba-3.0.24"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-01] Samba: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Samba: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-fs/samba", unaffected: make_list("ge 3.0.24"), vulnerable: make_list("lt 3.0.24")
)) { security_warning(0); exit(0); }
