# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-03.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24352);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200702-03");
 script_cve_id("CVE-2006-6931");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-03
(Snort: Denial of Service)


    Randy Smith, Christian Estan and Somesh Jha discovered that the rule
    matching algorithm of Snort can be exploited in a way known as a
    "backtracking attack" to perform numerous time-consuming operations.
  
Impact

    A remote attacker could send specially crafted network packets, which
    would result in the cessation of the detections and the consumption of
    the CPU resources.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6931


Solution: 
    All Snort users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/snort-2.6.1.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-03] Snort: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Snort: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/snort", unaffected: make_list("ge 2.6.1.2"), vulnerable: make_list("lt 2.6.1.2")
)) { security_warning(0); exit(0); }
