# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24353);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200702-04");
 script_cve_id("CVE-2007-0855");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-04
(RAR, UnRAR: Buffer overflow)


    RAR and UnRAR contain a boundary error when processing
    password-protected archives that could result in a stack-based buffer
    overflow.
  
Impact

    A remote attacker could entice a user to process a specially crafted
    password-protected archive and execute arbitrary code with the rights
    of the user uncompressing the archive.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0855


Solution: 
    All UnRAR users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/unrar-3.7.3"
    All RAR users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/rar-3.7.0_beta1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-04] RAR, UnRAR: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'RAR, UnRAR: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/unrar", unaffected: make_list("ge 3.7.3"), vulnerable: make_list("lt 3.7.3")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "app-arch/rar", unaffected: make_list("ge 3.7.0_beta1"), vulnerable: make_list("lt 3.7.0_beta1")
)) { security_warning(0); exit(0); }
