# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24368);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200702-07");
 script_cve_id("CVE-2007-0243");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-07
(Sun JDK/JRE: Execution of arbitrary code)


    A anonymous researcher discovered that an error in the handling of a
    GIF image with a zero width field block leads to a memory corruption
    flaw.
  
Impact

    An attacker could entice a user to run a specially crafted Java applet
    or application that would load a crafted GIF image, which could result
    in escalation of privileges and unauthorized access to system
    resources.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-CVE-2007-0243


Solution: 
    All Sun Java Development Kit 1.5 users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-java/sun-jdk-1.5.0.10"
    All Sun Java Development Kit 1.4 users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "=dev-java/sun-jdk-1.4.2*"
    All Sun Java Runtime Environment 1.5 users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-java/sun-jre-bin-1.5.0.10"
    All Sun Java Runtime Environment 1.4 users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "=dev-java/sun-jre-bin-1.4.2*"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-07] Sun JDK/JRE: Execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Sun JDK/JRE: Execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-java/sun-jdk", unaffected: make_list("ge 1.5.0.10", "rge 1.4.2.13"), vulnerable: make_list("lt 1.5.0.10", "lt 1.4.2.13")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "dev-java/sun-jre-bin", unaffected: make_list("ge 1.5.0.10", "rge 1.4.2.13"), vulnerable: make_list("lt 1.5.0.10", "lt 1.4.2.13")
)) { security_warning(0); exit(0); }
