# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24722);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200702-10");
 script_cve_id("CVE-2006-3788", "CVE-2006-3789", "CVE-2006-3790", "CVE-2006-3791", "CVE-2006-3792");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-10
(UFO2000: Multiple vulnerabilities)


    Five vulnerabilities were found: a buffer overflow in recv_add_unit();
    a problem with improperly trusting user-supplied string information in
    decode_stringmap(); several issues with array manipulation via various
    commands during play; an SQL injection in server_protocol.cpp; and
    finally, a second buffer overflow in recv_map_data().
  
Impact

    An attacker could send crafted network traffic as part of a
    multi-player game that could result in remote code execution on the
    remote opponent or the server. A remote attacker could also run
    arbitrary SQL queries against the server account database, and perform
    a Denial of Service on a remote opponent by causing the game to crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3788
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3789
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3790
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3791
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3792
    http://www.gentoo.org/security/en/glsa/glsa-200608-14.xml


Solution: 
    UFO2000 currently depends on the dumb-0.9.2 library, which has been
    removed from portage due to security problems (GLSA 200608-14) .
    Because of this, UFO2000 has been masked, and we recommend unmerging
    the package until the next beta release can remove the dependency on
    dumb.
    # emerge --ask --verbose --unmerge ufo2000
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-10] UFO2000: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'UFO2000: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "games-strategy/ufo2000", unaffected: make_list("ge 0.7.1062"), vulnerable: make_list("lt 0.7.1062")
)) { security_warning(0); exit(0); }
