# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200702-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24732);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200702-12");
 script_cve_id("CVE-2007-0619");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200702-12
(CHMlib: User-assisted remote execution of arbitrary code)


    When certain CHM files that contain tables and objects stored in pages
    are parsed by CHMlib, an unsanitized value is passed to the alloca()
    function resulting in a shift of the stack pointer to arbitrary memory
    locations.
  
Impact

    An attacker could entice a user to open a specially crafted CHM file,
    resulting in the execution of arbitrary code with the permissions of
    the user viewing the file.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=468
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0619


Solution: 
    All CHMlib users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-doc/chmlib-0.39"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200702-12] CHMlib: User-assisted remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'CHMlib: User-assisted remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-doc/chmlib", unaffected: make_list("ge 0.39"), vulnerable: make_list("lt 0.39")
)) { security_warning(0); exit(0); }
