# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24773);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-06");
 script_cve_id("CVE-2006-4811");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-06
(AMD64 x86 emulation Qt library: Integer overflow)


    An integer overflow flaw has been found in the pixmap handling of Qt,
    making the AMD64 x86 emulation Qt library vulnerable as well.
  
Impact

    By enticing a user to open a specially crafted pixmap image in an
    application using the AMD64 x86 emulation Qt library, a remote attacker
    could cause an application crash or the remote execution of arbitrary
    code with the rights of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200611-02.xml
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4811


Solution: 
    All AMD64 x86 emulation Qt library users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/emul-linux-x86-qtlibs-10.0"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-06] AMD64 x86 emulation Qt library: Integer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'AMD64 x86 emulation Qt library: Integer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emulation/emul-linux-x86-qtlibs", unaffected: make_list("ge 10.0"), vulnerable: make_list("lt 10.0")
)) { security_warning(0); exit(0); }
