# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24829);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-12");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-12
(SILC Server: Denial of Service)


    Frank Benkstein discovered a possible NULL pointer dereference in
    apps/silcd/command.c if a new channel is created without specifying a
    valid hmac or cipher algorithm name.
  
Impact

    A remote attacker could cause the server to crash, resulting in a
    Denial of Service.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    All SILC Server users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-im/silc-server-1.0.2-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-12] SILC Server: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'SILC Server: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-im/silc-server", unaffected: make_list("ge 1.0.2-r1"), vulnerable: make_list("lt 1.0.2-r1")
)) { security_warning(0); exit(0); }
