# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24839);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-14");
 script_cve_id("CVE-2007-1306");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-14
(Asterisk: SIP Denial of Service)


    The MU Security Research Team discovered that Asterisk contains a
    NULL-pointer dereferencing error in the SIP channel when handling
    request messages.
  
Impact

    A remote attacker could cause an Asterisk server listening for SIP
    messages to crash by sending a specially crafted SIP request message.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1306
    http://labs.musecurity.com/advisories/MU-200703-01.txt


Solution: 
    All Asterisk users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose net-misc/asterisk
    Note: Asterisk 1.0.x is no longer supported upstream so users should
    consider upgrading to Asterisk 1.2.x.
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-14] Asterisk: SIP Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Asterisk: SIP Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-misc/asterisk", unaffected: make_list("ge 1.2.14-r1", "rge 1.0.12-r1"), vulnerable: make_list("lt 1.2.14-r1")
)) { security_warning(0); exit(0); }
