# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24840);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-15");
 script_cve_id("CVE-2007-0555", "CVE-2007-0556");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-15
(PostgreSQL: Multiple vulnerabilities)


    PostgreSQL does not correctly check the data types of the SQL function
    arguments under unspecified circumstances nor the format of the
    provided tables in the query planner.
  
Impact

    A remote authenticated attacker could send specially crafted queries to
    the server that could result in a server crash and possibly the
    unauthorized reading of some database content or arbitrary memory.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0555
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0556


Solution: 
    All PostgreSQL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-db/postgresql"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-15] PostgreSQL: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PostgreSQL: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/postgresql", unaffected: make_list("ge 8.0.11", "rge 7.4.16", "rge 7.3.13"), vulnerable: make_list("lt 8.0.11")
)) { security_warning(0); exit(0); }
