# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-16.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24841);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-16");
 script_cve_id("CVE-2007-0774");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-16
(Apache JK Tomcat Connector: Remote execution of arbitrary code)


    ZDI reported an unsafe memory copy in mod_jk that was discovered by an
    anonymous researcher in the map_uri_to_worker function of
    native/common/jk_uri_worker_map.c .
  
Impact

    A remote attacker can send a long URL request to an Apache server using
    Tomcat. That can trigger the vulnerability and lead to a stack-based
    buffer overflow, which could result in the execution of arbitrary code
    with the permissions of the Apache user.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0774


Solution: 
    All Apache Tomcat users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apache/mod_jk-1.2.21-r1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-16] Apache JK Tomcat Connector: Remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Apache JK Tomcat Connector: Remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apache/mod_jk", unaffected: make_list("ge 1.2.21-r1"), vulnerable: make_list("lt 1.2.21-r1")
)) { security_hole(0); exit(0); }
