# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24889);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-23");
 script_cve_id("CVE-2007-1049", "CVE-2007-1230", "CVE-2007-1244", "CVE-2007-1409");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-23
(WordPress: Multiple vulnerabilities)


    WordPress contains cross-site scripting or cross-site scripting forgery
    vulnerabilities reported by:
    g30rg3_x in the "year"
    parameter of the wp_title() function
    Alexander Concha in the
    "demo" parameter of wp-admin/admin.php
    Samenspender and Stefan
    Friedli in the "post" parameter of wp-admin/post.php and
    wp-admin/page.php, in the "cat_ID" parameter of wp-admin/categories.php
    and in the "c" parameter of wp-admin/comment.php
    PsychoGun in
    the "file" parameter of wp-admin/templates.php
    Additionally, WordPress prints the full PHP script paths in some error
    messages.
  
Impact

    The cross-site scripting vulnerabilities can be triggered to steal
    browser session data or cookies. A remote attacker can entice a user to
    browse to a specially crafted web page that can trigger the cross-site
    request forgery vulnerability and perform arbitrary WordPress actions
    with the permissions of the user. Additionally, the path disclosure
    vulnerability could help an attacker to perform other attacks.
  
Workaround

    There is no known workaround at this time for all these
    vulnerabilities.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1049
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1230
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1244
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1409
    http://secunia.com/advisories/24430/


Solution: 
    Due to the numerous recently discovered vulnerabilities in WordPress,
    this package has been masked in the portage tree. All WordPress users
    are advised to unmerge it.
    # emerge --unmerge "www-apps/wordpress"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-23] WordPress: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'WordPress: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/wordpress", unaffected: make_list(), vulnerable: make_list("le 2.1.2")
)) { security_warning(0); exit(0); }
