# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-24.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24929);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-24");
 script_cve_id("CVE-2006-5864");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-24
(mgv: Stack overflow in included gv code)


    mgv includes code from gv that does not properly boundary check
    user-supplied data before copying it into process buffers.
  
Impact

    An attacker could entice a user to open a specially crafted Postscript
    document with mgv and possibly execute arbitrary code with the rights
    of the user running mgv.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5864
    http://www.gentoo.org/security/en/glsa/glsa-200611-20.xml


Solution: 
    mgv is currently unmaintained, and the mgv website no longer exists. As
    such, the mgv package has been masked in Portage. We recommend that
    users select an alternate Postscript viewer such as ghostview or
    GSview, and unmerge mgv:
    # emerge --unmerge "app-text/mgv"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-24] mgv: Stack overflow in included gv code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'mgv: Stack overflow in included gv code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/mgv", unaffected: make_list(), vulnerable: make_list("le 3.1.5")
)) { security_warning(0); exit(0); }
