# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25019);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-06");
 script_cve_id("CVE-2006-5864");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-06
(Evince: Stack overflow in included gv code)


    Evince includes code from GNU gv that does not properly boundary check
    user-supplied data before copying it into process buffers.
  
Impact

    An attacker could entice a user to open a specially crafted PostScript
    document with Evince and possibly execute arbitrary code with the
    rights of the user running Evince.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5864
    http://www.gentoo.org/security/en/glsa/glsa-200611-20.xml


Solution: 
    All Evince users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-text/evince-0.6.1-r3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-06] Evince: Stack overflow in included gv code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Evince: Stack overflow in included gv code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/evince", unaffected: make_list("ge 0.6.1-r3"), vulnerable: make_list("lt 0.6.1-r3")
)) { security_warning(0); exit(0); }
