# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25020);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-07");
 script_cve_id("CVE-2007-0002", "CVE-2007-1466");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-07
(libwpd: Multiple vulnerabilities)


    libwpd contains heap-based overflows in two functions that convert
    WordPerfect document tables. In addition, it contains an integer
    overflow in a text-conversion function.
  
Impact

    An attacker could entice a user to convert a specially crafted
    WordPerfect file, resulting in a crash or possibly the execution of
    arbitrary code with the rights of the user running libwpd.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0002
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1466


Solution: 
    All libwpd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-text/libwpd-0.8.9"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-07] libwpd: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'libwpd: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/libwpd", unaffected: make_list("ge 0.8.9"), vulnerable: make_list("lt 0.8.9")
)) { security_warning(0); exit(0); }
