# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25054);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-09");
 script_cve_id("CVE-2007-1246");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-09
(xine-lib: Heap-based buffer overflow)


    xine-lib does not check boundaries on data being read into buffers from
    DMO video files in code that is shared with MPlayer
    (DMO_VideoDecoder.c).
  
Impact

    An attacker could entice a user to play a specially crafted DMO video
    file with a player using xine-lib, potentially resulting in the
    execution of arbitrary code with the privileges of the user running the
    player.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1246


Solution: 
    All xine-lib users on the x86 platform should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/xine-lib-1.1.4-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-09] xine-lib: Heap-based buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'xine-lib: Heap-based buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/xine-lib", arch: "x86", unaffected: make_list("ge 1.1.4-r2"), vulnerable: make_list("lt 1.1.4-r2")
)) { security_warning(0); exit(0); }
