# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25107);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-19");
 script_cve_id("CVE-2007-1253");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-19
(Blender: User-assisted remote execution of arbitrary code)


    Stefan Cornelius of Secunia Research discovered an insecure use of the
    "eval()" function in kmz_ImportWithMesh.py.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    Blender file (.kmz or .kml), resulting in the execution of arbitrary
    Python code with the privileges of the user running Blender.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1253


Solution: 
    All Blender users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-gfx/blender-2.43"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-19] Blender: User-assisted remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Blender: User-assisted remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-gfx/blender", unaffected: make_list("ge 2.43"), vulnerable: make_list("lt 2.43")
)) { security_warning(0); exit(0); }
