# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-21.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25109);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-21");
 script_cve_id("CVE-2007-1745", "CVE-2007-1997");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-21
(ClamAV: Multiple vulnerabilities)


    iDefense Labs have reported a stack-based buffer overflow in the
    cab_unstore() function when processing negative values in .cab files.
    Multiple file descriptor leaks have also been reported in chmunpack.c,
    pdf.c and dblock.c when processing .chm files.
  
Impact

    A remote attacker could send a specially crafted CHM file to the
    scanner, possibly resulting in the remote execution of arbitrary code
    with the privileges of the user running ClamAV.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1745
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1997


Solution: 
    All ClamAV users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-antivirus/clamav-0.90.2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-21] ClamAV: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ClamAV: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-antivirus/clamav", unaffected: make_list("ge 0.90.2"), vulnerable: make_list("lt 0.90.2")
)) { security_hole(0); exit(0); }
