# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25132);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-02");
 script_cve_id("CVE-2007-1351");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-02
(FreeType: User-assisted execution of arbitrary code)


    Greg MacManus of iDefense Labs has discovered an integer overflow in
    the function bdfReadCharacters() when parsing BDF fonts.
  
Impact

    A remote attacker could entice a user to use a specially crafted BDF
    font, possibly resulting in a heap-based buffer overflow and the remote
    execution of arbitrary code.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1351


Solution: 
    All FreeType users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/freetype-2.1.10-r3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-02] FreeType: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'FreeType: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/freetype", unaffected: make_list("ge 2.1.10-r3"), vulnerable: make_list("lt 2.1.10-r3")
)) { security_warning(0); exit(0); }
