# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25160);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-06");
 script_cve_id("CVE-2007-1667");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-06
(X.Org X11 library: Multiple integer overflows)


    Multiple integer overflows have been reported in the XGetPixel()
    function of the X.Org X11 library.
  
Impact

    By enticing a user to open a specially crafted image, an attacker could
    cause a Denial of Service or an integer overflow, potentially resulting
    in the execution of arbitrary code with root privileges.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1667


Solution: 
    All X.Org X11 library users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/libX11-1.0.3-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-06] X.Org X11 library: Multiple integer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'X.Org X11 library: Multiple integer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/libX11", unaffected: make_list("ge 1.0.3-r2"), vulnerable: make_list("lt 1.0.3-r2")
)) { security_hole(0); exit(0); }
