# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25208);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-12");
 script_cve_id("CVE-2007-2138");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-12
(PostgreSQL: Privilege escalation)


    An error involving insecure search_path settings in the SECURITY
    DEFINER functions has been reported in PostgreSQL.
  
Impact

    If allowed to call a SECURITY DEFINER function, an attacker could gain
    the SQL privileges of the owner of the called function.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.postgresql.org/docs/techdocs.77
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2138


Solution: 
    All PostgreSQL users should upgrade to the latest version and fix their
    SECURITY DEFINER functions:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-db/postgresql"
    In order to fix the SECURITY DEFINER functions, PostgreSQL users are
    advised to refer to the PostgreSQL documentation: http://www.postgresql
    .org/docs/techdocs.77
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-12] PostgreSQL: Privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PostgreSQL: Privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/postgresql", unaffected: make_list("ge 8.0.13", "rge 7.4.17", "rge 7.3.19"), vulnerable: make_list("lt 8.0.13")
)) { security_warning(0); exit(0); }
