# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25340);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-19");
 script_cve_id("CVE-2007-1001", "CVE-2007-1285", "CVE-2007-1286", "CVE-2007-1484", "CVE-2007-1521", "CVE-2007-1583", "CVE-2007-1700", "CVE-2007-1701", "CVE-2007-1711", "CVE-2007-1717", "CVE-2007-1718", "CVE-2007-1864", "CVE-2007-1900", "CVE-2007-2509", "CVE-2007-2510", "CVE-2007-2511");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-19
(PHP: Multiple vulnerabilities)


    Several vulnerabilities were found in PHP, most of them during the
    Month Of PHP Bugs (MOPB) by Stefan Esser. The most severe of these
    vulnerabilities are integer overflows in wbmp.c from the GD library
    (CVE-2007-1001) and in the substr_compare() PHP 5 function
    (CVE-2007-1375). Ilia Alshanetsky also reported a buffer overflow in
    the make_http_soap_request() and in the user_filter_factory_create()
    functions (CVE-2007-2510, CVE-2007-2511), and Stanislav Malyshev
    discovered another buffer overflow in the bundled XMLRPC library
    (CVE-2007-1864). Additionally, the session_regenerate_id() and the
    array_user_key_compare() functions contain a double-free vulnerability
    (CVE-2007-1484, CVE-2007-1521). Finally, there exist implementation
    errors in the Zend engine, in the mb_parse_str(), the unserialize() and
    the mail() functions and other elements.
  
Impact

    Remote attackers might be able to exploit these issues in PHP
    applications making use of the affected functions, potentially
    resulting in the execution of arbitrary code, Denial of Service,
    execution of scripted contents in the context of the affected site,
    security bypass or information leak.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1001
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1285
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1286
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1484
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1521
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1583
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1700
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1701
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1711
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1717
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1718
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1864
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1900
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2509
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2510
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2511


Solution: 
    All PHP 5 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/php-5.2.2"
    All PHP 4 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/php-4.4.7"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-19] PHP: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PHP: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/php", unaffected: make_list("rge 4.4.7", "ge 5.2.2"), vulnerable: make_list("lt 5.2.2")
)) { security_hole(0); exit(0); }
