# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-21.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25360);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-21");
 script_cve_id("CVE-2007-1246", "CVE-2007-1387");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-21
(MPlayer: Two buffer overflows)


    A buffer overflow has been reported in the DMO_VideoDecoder_Open()
    function in file loader/dmo/DMO_VideoDecoder.c. Another buffer overflow
    has been reported in the DS_VideoDecoder_Open() function in file
    loader/dshow/DS_VideoDecoder.c.
  
Impact

    A remote attacker could entice a user to open a specially crafted video
    file, potentially resulting in the execution of arbitrary code with the
    privileges of the user running MPlayer.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1246
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1387
    http://www.gentoo.org/security/en/glsa/glsa-200704-09.xml


Solution: 
    All MPlayer users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-video/mplayer-1.0.20070321"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-21] MPlayer: Two buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MPlayer: Two buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-video/mplayer", unaffected: make_list("ge 1.0.20070321"), vulnerable: make_list("lt 1.0.20070321")
)) { security_warning(0); exit(0); }
