# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25382);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200705-23");
 script_cve_id("CVE-2007-2435", "CVE-2007-2788", "CVE-2007-2789");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-23
(Sun JDK/JRE: Multiple vulnerabilities)


    An unspecified vulnerability involving an "incorrect use of system
    classes" was reported by the Fujitsu security team. Additionally, Chris
    Evans from the Google Security Team reported an integer overflow
    resulting in a buffer overflow in the ICC parser used with JPG or BMP
    files, and an incorrect open() call to /dev/tty when processing certain
    BMP files.
  
Impact

    A remote attacker could entice a user to run a specially crafted Java
    class or applet that will trigger one of the vulnerabilities. This
    could lead to the execution of arbitrary code outside of the Java
    sandbox and of the Java security restrictions, or crash the Java
    application or the browser.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2435
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2788
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2789


Solution: 
    All Sun Java Development Kit users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-java/sun-jdk"
    All Sun Java Runtime Environment users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-java/sun-jre-bin"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-23] Sun JDK/JRE: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Sun JDK/JRE: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-java/sun-jre-bin", unaffected: make_list("ge 1.5.0.11", "rge 1.4.2.14"), vulnerable: make_list("lt 1.5.0.11")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "dev-java/sun-jdk", unaffected: make_list("ge 1.5.0.11", "rge 1.4.2.14"), vulnerable: make_list("lt 1.5.0.11")
)) { security_warning(0); exit(0); }
