# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25561);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-06");
 script_cve_id("CVE-2007-1362", "CVE-2007-1558", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-06
(Mozilla products: Multiple vulnerabilities)


    Mozilla developers fixed several bugs involving memory corruption
    through various vectors (CVE-2007-2867, CVE-2007-2868). Additionally,
    several errors leading to crash, memory exhaustion or CPU consumption
    were fixed (CVE-2007-1362, CVE-2007-2869). Finally, errors related to
    the APOP protocol (CVE-2007-1558), XSS prevention (CVE-2007-2870) and
    spoofing prevention (CVE-2007-2871) were fixed.
  
Impact

    A remote attacker could entice a user to view a specially crafted web
    page that will trigger one of the vulnerabilities, possibly leading to
    the execution of arbitrary code or a Denial of Service. It is also
    possible for an attacker to spoof the address bar or other browser
    elements, obtain sensitive APOP information, or perform cross-site
    scripting attacks, leading to the exposure of sensitive information,
    like user credentials.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1362
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1558
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2867
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2868
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2869
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2870
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2871


Solution: 
    All Mozilla Firefox users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/mozilla-firefox-2.0.0.4"
    All Mozilla Firefox binary users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/mozilla-firefox-bin-2.0.0.4"
    All Mozilla Thunderbird users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/mozilla-thunderbird-2.0.0.4"
    All Mozilla Thunderbird binary users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/mozilla-thunderbird-bin-2.0.0.4"
    All SeaMonkey users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/seamonkey-1.1.2"
    All SeaMonkey binary users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/seamonkey-bin-1.1.2"
    All XULRunner users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-libs/xulrunner-1.8.1.4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-06] Mozilla products: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Mozilla products: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/mozilla-firefox", unaffected: make_list("ge 2.0.0.4"), vulnerable: make_list("lt 2.0.0.4")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "net-libs/xulrunner", unaffected: make_list("ge 1.8.1.4"), vulnerable: make_list("lt 1.8.1.4")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "mail-client/mozilla-thunderbird-bin", unaffected: make_list("ge 2.0.0.4", "rge 1.5.0.12"), vulnerable: make_list("lt 2.0.0.4")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "mail-client/mozilla-thunderbird", unaffected: make_list("ge 2.0.0.4", "rge 1.5.0.12"), vulnerable: make_list("lt 2.0.0.4")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "www-client/seamonkey", unaffected: make_list("ge 1.1.2"), vulnerable: make_list("lt 1.1.2")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "www-client/mozilla-firefox-bin", unaffected: make_list("ge 2.0.0.4"), vulnerable: make_list("lt 2.0.0.4")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "www-client/seamonkey-bin", unaffected: make_list("ge 1.1.2"), vulnerable: make_list("lt 1.1.2")
)) { security_warning(0); exit(0); }
