# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200707-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25719);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200707-06");
 script_cve_id("CVE-2007-2194");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200707-06
(XnView: Stack-based buffer overflow)


    XnView is vulnerable to a stack-based buffer overflow while processing
    an XPM file with an overly long section string (greater than 1024
    bytes).
  
Impact

    An attacker could entice a user to view a specially crafted XPM file
    with XnView that could trigger the vulnerability and possibly execute
    arbitrary code with the rights of the user running XnView.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2194


Solution: 
    No update appears to be forthcoming from the XnView developer and
    XnView is proprietary, so the XnView package has been masked in
    Portage. We recommend that users select an alternate graphics viewer
    and conversion utility, and unmerge XnView:
    # emerge --unmerge xnview
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200707-06] XnView: Stack-based buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'XnView: Stack-based buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-misc/xnview", arch: "x86", unaffected: make_list(), vulnerable: make_list("lt 1.70")
)) { security_warning(0); exit(0); }
