# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200707-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25791);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200707-09");
 script_cve_id("CVE-2006-4519", "CVE-2007-2949");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200707-09
(GIMP: Multiple integer overflows)


    Sean Larsson from iDefense Labs discovered multiple integer overflows
    in various GIMP plugins (CVE-2006-4519). Stefan Cornelius from Secunia
    Research discovered an integer overflow in the
    seek_to_and_unpack_pixeldata() function when processing PSD files
    (CVE-2007-2949).
  
Impact

    A remote attacker could entice a user to open a specially crafted image
    file, possibly resulting in the execution of arbitrary code with the
    privileges of the user running GIMP.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4519
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2949


Solution: 
    All GIMP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-gfx/gimp-2.2.16"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200707-09] GIMP: Multiple integer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'GIMP: Multiple integer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-gfx/gimp", unaffected: make_list("ge 2.2.16"), vulnerable: make_list("lt 2.2.16")
)) { security_warning(0); exit(0); }
