# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25869);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-04");
 script_cve_id("CVE-2007-3725");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-04
(ClamAV: Denial of Service)


    Metaeye Security Group reported a NULL pointer dereference in ClamAV
    when processing RAR archives.
  
Impact

    A remote attacker could send a specially crafted RAR archive to the
    clamd daemon, resulting in a crash and a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3725


Solution: 
    All ClamAV users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-antivirus/clamav-0.91"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-04] ClamAV: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ClamAV: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-antivirus/clamav", unaffected: make_list("ge 0.91"), vulnerable: make_list("lt 0.91")
)) { security_warning(0); exit(0); }
