# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25872);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-07");
 script_cve_id("CVE-2007-3770");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-07
(Xfce Terminal: Remote arbitrary code execution)


    Lasse Karkkainen discovered that the function terminal_helper_execute()
    in file terminal-helper.c does not properly escape the URIs before
    processing.
  
Impact

    A remote attacker could entice a user to open a specially crafted link,
    possibly leading to the remote execution of arbitrary code with the
    privileges of the user running Xfce Terminal. Note that the exploit
    code depends on the browser used to open the crafted link.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3770


Solution: 
    All Xfce Terminal users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=xfce-extra/terminal-0.2.6_p25931"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-07] Xfce Terminal: Remote arbitrary code execution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Xfce Terminal: Remote arbitrary code execution');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "xfce-extra/terminal", unaffected: make_list("ge 0.2.6_p25931"), vulnerable: make_list("lt 0.2.6_p25931")
)) { security_warning(0); exit(0); }
