# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25917);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-11");
 script_cve_id("CVE-2007-3946", "CVE-2007-3947", "CVE-2007-3948", "CVE-2007-3949", "CVE-2007-3950");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-11
(Lighttpd: Multiple vulnerabilities)


    Stefan Esser discovered errors with evidence of memory corruption in
    the code parsing the headers. Several independent researchers also
    reported errors involving the handling of HTTP headers, the mod_auth
    and mod_scgi modules, and the limitation of active connections.
  
Impact

    A remote attacker can trigger any of these vulnerabilities by sending
    malicious data to the server, which may lead to a crash or memory
    exhaustion, and potentially the execution of arbitrary code.
    Additionally, access-deny settings can be evaded by appending a final /
    to a URL.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3946
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3947
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3948
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3949
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3950


Solution: 
    All Lighttpd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-servers/lighttpd-1.4.16"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-11] Lighttpd: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Lighttpd: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-servers/lighttpd", unaffected: make_list("ge 1.4.16"), vulnerable: make_list("lt 1.4.16")
)) { security_warning(0); exit(0); }
