# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25918);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-12");
 script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-12
(Wireshark: Multiple vulnerabilities)


    Wireshark doesn\'t properly handle chunked encoding in HTTP responses
    (CVE-2007-3389), iSeries capture files (CVE-2007-3390), certain types
    of DCP ETSI packets (CVE-2007-3391), and SSL or MMS packets
    (CVE-2007-3392). An off-by-one error has been discovered in the
    DHCP/BOOTP dissector when handling DHCP-over-DOCSIS packets
    (CVE-2007-3393).
  
Impact

    A remote attacker could send specially crafted packets on a network
    being monitored with Wireshark, possibly resulting in the execution of
    arbitrary code with the privileges of the user running Wireshark which
    might be the root user, or a Denial of Service.
  
Workaround

    In order to prevent root compromise, take network captures with tcpdump
    and analyze them running Wireshark as a least privileged user.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3389
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3390
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3391
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3392
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3393


Solution: 
    All Wireshark users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/wireshark-0.99.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-12] Wireshark: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Wireshark: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/wireshark", unaffected: make_list("ge 0.99.6"), vulnerable: make_list("lt 0.99.6")
)) { security_warning(0); exit(0); }
