# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25921);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-15");
 script_cve_id("CVE-2007-1860");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-15
(Apache mod_jk: Directory traversal)


    Apache mod_jk decodes the URL within Apache before passing them to
    Tomcat, which decodes them a second time.
  
Impact

    A remote attacker could browse a specially crafted URL on an Apache
    server running mod_jk, possibly gaining access to restricted resources.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1860


Solution: 
    All Apache mod_jk users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apache/mod_jk-1.2.23"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-15] Apache mod_jk: Directory traversal");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Apache mod_jk: Directory traversal');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apache/mod_jk", unaffected: make_list("ge 1.2.23"), vulnerable: make_list("lt 1.2.23")
)) { security_warning(0); exit(0); }
