# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26041);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-01");
 script_cve_id("CVE-2007-3999", "CVE-2007-4000");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-01
(MIT Kerberos 5: Multiple vulnerabilities)


    A stack buffer overflow (CVE-2007-3999) has been reported in
    svcauth_gss_validate() of the RPC library of kadmind. Another
    vulnerability (CVE-2007-4000) has been found in
    kadm5_modify_policy_internal(), which does not check the return values
    of krb5_db_get_policy() correctly.
  
Impact

    The RPC related vulnerability can be exploited by a remote
    unauthenticated attacker to execute arbitrary code with root privileges
    on the host running kadmind. The second vulnerability requires the
    remote attacker to be authenticated and to have "modify policy"
    privileges. It could then also allow for the remote execution of
    arbitrary code.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3999
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4000


Solution: 
    All MIT Kerberos 5 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-crypt/mit-krb5-1.5.3-r1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-01] MIT Kerberos 5: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MIT Kerberos 5: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-crypt/mit-krb5", unaffected: make_list("ge 1.5.3-r1"), vulnerable: make_list("lt 1.5.3-r1")
)) { security_hole(0); exit(0); }
