# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-03.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26043);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-03");
 script_cve_id("CVE-2007-4337");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-03
(Streamripper: Buffer overflow)


    Chris Rohlf discovered several boundary errors in the
    httplib_parse_sc_header() function when processing HTTP headers.
  
Impact

    A remote attacker could entice a user to connect to a malicious
    streaming server, resulting in the execution of arbitrary code with the
    privileges of the user running Streamripper.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4337


Solution: 
    All Streamripper users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-sound/streamripper-1.62.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-03] Streamripper: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Streamripper: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-sound/streamripper", unaffected: make_list("ge 1.62.2"), vulnerable: make_list("lt 1.62.2")
)) { security_warning(0); exit(0); }
