# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26117);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200709-15");
 script_cve_id("CVE-2007-2788");
 script_cve_id("CVE-2007-2789");
 script_cve_id("CVE-2007-3503");
 script_cve_id("CVE-2007-3698");
 script_cve_id("CVE-2007-3716");
 script_cve_id("CVE-2007-3922");
 script_cve_id("CVE-2007-4381");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-15
(BEA JRockit: Multiple vulnerabilities)


    An integer overflow vulnerability exists in the embedded ICC profile
    image parser (CVE-2007-2788), an unspecified vulnerability exists in
    the font parsing implementation (CVE-2007-4381), and an error exists
    when processing XSLT stylesheets contained in XSLT Transforms in XML
    signatures (CVE-2007-3716), among other vulnerabilities.
  
Impact

    A remote attacker could trigger the integer overflow to execute
    arbitrary code or crash the JVM through a specially crafted file. Also,
    an attacker could perform unauthorized actions via an applet that
    grants certain privileges to itself because of the font parsing
    vulnerability. The error when processing XSLT stylesheets can be
    exploited to execute arbitrary code. Other vulnerabilities could lead
    to establishing restricted network connections to certain services,
    Cross Site Scripting and Denial of Service attacks.
  
Workaround

    There is no known workaround at this time for all these
    vulnerabilities.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2788
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2789
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3004
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3005
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3503
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3698
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3716
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3922
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4381


Solution: 
    All BEA JRockit users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-java/jrockit-jdk-bin-1.5.0.11_p1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-15] BEA JRockit: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'BEA JRockit: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-java/jrockit-jdk-bin", unaffected: make_list("ge 1.5.0.11_p1"), vulnerable: make_list("lt 1.5.0.11_p1")
)) { security_warning(0); exit(0); }
