# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26941);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-01");
 script_cve_id("CVE-2007-3999");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-01
(RPCSEC_GSS library: Buffer overflow)


    A stack based buffer overflow has been discovered in the
    svcauth_gss_validate() function in file lib/rpc/svc_auth_gss.c when
    processing an overly long string in a RPC message.
  
Impact

    A remote attacker could send a specially crafted RPC request to an
    application relying on this library, e.g NFSv4 or Kerberos
    (GLSA-200709-01), resulting in the execution of arbitrary code with the
    privileges of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3999
    http://www.gentoo.org/security/en/glsa/glsa-200709-01.xml


Solution: 
    All librpcsecgss users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-libs/librpcsecgss-0.16"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-01] RPCSEC_GSS library: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'RPCSEC_GSS library: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-libs/librpcsecgss", unaffected: make_list("ge 0.16"), vulnerable: make_list("lt 0.16")
)) { security_hole(0); exit(0); }
