# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26947);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200710-07");
 script_cve_id("CVE-2007-5137");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-07
(Tk: Buffer overflow)


    Reinhard Max discovered a boundary error in Tk when processing an
    interlaced GIF with two frames where the second is smaller than the
    first one.
  
Impact

    A remote attacker could entice a user to open a specially crafted GIF
    image with a Tk-based software, possibly resulting in the execution of
    arbitrary code with the privileges of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4851


Solution: 
    All Tk users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/tk-8.4.15-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-07] Tk: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Tk: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/tk", unaffected: make_list("ge 8.4.15-r1"), vulnerable: make_list("lt 8.4.15-r1")
)) { security_warning(0); exit(0); }
