# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27047);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-12");
 script_cve_id("CVE-2007-4033");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-12
(T1Lib: Buffer overflow)


    Hamid Ebadi discovered a boundary error in the
    intT1_EnvGetCompletePath() function which can lead to a buffer overflow
    when processing an overly long filename.
  
Impact

    A remote attacker could entice a user to open a font file with a
    specially crafted filename, possibly leading to the execution of
    arbitrary code with the privileges of the user running the application
    using T1Lib.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4033


Solution: 
    All T1Lib users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/t1lib-5.0.2-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-12] T1Lib: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'T1Lib: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/t1lib", unaffected: make_list("ge 5.0.2-r1"), vulnerable: make_list("lt 5.0.2-r1")
)) { security_warning(0); exit(0); }
