# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-13.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27048);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-13");
 script_cve_id("CVE-2007-4437", "CVE-2007-4438");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-13
(Ampache: Multiple vulnerabilities)


    LT discovered that the "match" parameter in albums.php is not properly
    sanitized before being processed. The Ampache development team also
    reported an error when handling user sessions.
  
Impact

    A remote attacker could provide malicious input to the application,
    possibly resulting in the execution of arbitrary SQL code. He could
    also entice a user to open a specially crafted link to steal the user\'s
    session.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4437
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4438


Solution: 
    All Ampache users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/ampache-3.3.3.5"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-13] Ampache: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Ampache: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/ampache", unaffected: make_list("ge 3.3.3.5"), vulnerable: make_list("lt 3.3.3.5")
)) { security_warning(0); exit(0); }
