# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27049);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-14");
 script_cve_id("CVE-2007-4323");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-14
(DenyHosts: Denial of Service)


    Daniel B. Cid discovered that DenyHosts used an incomplete regular
    expression to parse failed login attempts, a different issue than GLSA
    200701-01.
  
Impact

    A remote unauthenticated attacker can add arbitrary hosts into the
    blacklist, including the "all" keyword, by submitting specially crafted
    version identification strings to the SSH server banner. An attacker
    may use this to prevent legitimate users from accessing a host
    remotely.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4323


Solution: 
    All DenyHosts users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-admin/denyhosts-2.6-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-14] DenyHosts: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'DenyHosts: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-admin/denyhosts", unaffected: make_list("ge 2.6-r1"), vulnerable: make_list("lt 2.6-r1")
)) { security_warning(0); exit(0); }
