# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27050);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-15");
 script_cve_id("CVE-2007-4569");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-15
(KDM: Local privilege escalation)


    Kees Huijgen discovered an error when checking the credentials which
    can lead to a login without specifying a password. This only occurs
    when auto login is configured for at least one user and a password is
    required to shut down the machine.
  
Impact

    A local attacker could gain root privileges and execute arbitrary
    commands by logging in as root without specifying root\'s password.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4569


Solution: 
    All KDM users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=kde-base/kdm-3.5.7-r2"
    All kdebase users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=kde-base/kdebase-3.5.7-r4"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-15] KDM: Local privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'KDM: Local privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "kde-base/kdebase", unaffected: make_list("ge 3.5.7-r4"), vulnerable: make_list("lt 3.5.7-r4")
)) { security_hole(0); exit(0); }
if (qpkg_check(package: "kde-base/kdm", unaffected: make_list("ge 3.5.7-r2"), vulnerable: make_list("lt 3.5.7-r2")
)) { security_hole(0); exit(0); }
