# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-17.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27068);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-17");
 script_cve_id("CVE-2007-5007");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-17
(Balsa: Buffer overflow)


    Evil Ninja Squirrel discovered a stack-based buffer overflow in the
    ir_fetch_seq() function when receiving a long response to a FETCH
    command (CVE-2007-5007).
  
Impact

    A remote attacker could entice a user to connect to a malicious or
    compromised IMAP server, possibly leading to the execution of arbitrary
    code with the rights of the user running Balsa.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5007


Solution: 
    All Balsa users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/balsa-2.3.20"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-17] Balsa: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Balsa: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "mail-client/balsa", unaffected: make_list("ge 2.3.20"), vulnerable: make_list("lt 2.3.20")
)) { security_warning(0); exit(0); }
