# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27517);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-19");
 script_cve_id("CVE-2007-1536", "CVE-2007-2799");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-19
(The Sleuth Kit: Integer underflow)


    Jean-Sebastien Guay-Leroux reported an integer underflow in the
    file_printf() function of the "file" utility which is bundled with The
    Sleuth Kit (CVE-2007-1536, GLSA 200703-26). Note that Gentoo is not
    affected by the improper fix for this vulnerability (identified as
    CVE-2007-2799, see GLSA 200705-25) since version 4.20 of "file" was
    never shipped with The Sleuth Kit ebuilds.
  
Impact

    A remote attacker could entice a user to run The Sleuth Kit on a file
    system containing a specially crafted file that would trigger a
    heap-based buffer overflow possibly leading to the execution of
    arbitrary code with the rights of the user running The Sleuth Kit.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1536
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2799
    http://www.gentoo.org/security/en/glsa/glsa-200703-26.xml
    http://www.gentoo.org/security/en/glsa/glsa-200705-25.xml


Solution: 
    All The Sleuth Kit users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-forensics/sleuthkit-2.0.9"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-19] The Sleuth Kit: Integer underflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'The Sleuth Kit: Integer underflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-forensics/sleuthkit", unaffected: make_list("ge 2.0.9"), vulnerable: make_list("lt 2.0.9")
)) { security_warning(0); exit(0); }
