# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-21.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27553);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-21");
 script_cve_id("CVE-2007-5423");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-21
(TikiWiki: Arbitrary command execution)


    ShAnKaR reported that input passed to the "f" array parameter in
    tiki-graph_formula.php is not properly verified before being used to
    execute PHP functions.
  
Impact

    An attacker could execute arbitrary code with the rights of the user
    running the web server by passing a specially crafted parameter string
    to the tiki-graph_formula.php file.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5423


Solution: 
    All TikiWiki users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/tikiwiki-1.9.8.1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-21] TikiWiki: Arbitrary command execution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'TikiWiki: Arbitrary command execution');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/tikiwiki", unaffected: make_list("ge 1.9.8.1"), vulnerable: make_list("lt 1.9.8.1")
)) { security_hole(0); exit(0); }
