# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-30.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27592);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-30");
 script_cve_id("CVE-2007-4995");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-30
(OpenSSL: Remote execution of arbitrary code)


    Andy Polyakov reported a vulnerability in the OpenSSL toolkit, that is
    caused due to an unspecified off-by-one error within the DTLS
    implementation.
  
Impact

    A remote attacker could exploit this issue to execute arbitrary code or
    cause a Denial of Service. Only clients and servers explicitly using
    DTLS are affected, systems using SSL and TLS are not.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4995


Solution: 
    All OpenSSL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-libs/openssl-0.9.8f"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-30] OpenSSL: Remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenSSL: Remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-libs/openssl", unaffected: make_list("ge 0.9.8f"), vulnerable: make_list("lt 0.9.8f")
)) { security_hole(0); exit(0); }
