# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-31.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27593);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-31");
 script_cve_id("CVE-2007-5540", "CVE-2007-5541");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-31
(Opera: Multiple vulnerabilities)


    Michael A. Puls II discovered an unspecified flaw when launching
    external email or newsgroup clients (CVE-2007-5541). David Bloom
    discovered that when displaying frames from different websites, the
    same-origin policy is not correctly enforced (CVE-2007-5540).
  
Impact

    An attacker could potentially exploit the first vulnerability to
    execute arbitrary code with the privileges of the user running Opera by
    enticing a user to visit a specially crafted URL. Note that this
    vulnerability requires an external e-mail or newsgroup client
    configured in Opera to be exploitable. The second vulnerability allows
    an attacker to execute arbitrary script code in a user\'s browser
    session in context of other sites or the theft of browser credentials.
  
Workaround

    There is no known workaround at this time for all these
    vulnerabilities.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5540
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5541


Solution: 
    All Opera users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/opera-9.24"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-31] Opera: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Opera: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/opera", unaffected: make_list("ge 9.24"), vulnerable: make_list("lt 9.24")
)) { security_warning(0); exit(0); }
