# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27612);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-02");
 script_cve_id("CVE-2007-4752");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-02
(OpenSSH: Security bypass)


    Jan Pechanec discovered that OpenSSH uses a trusted X11 cookie when it
    cannot create an untrusted one.
  
Impact

    An attacker could bypass the SSH client security policy and gain
    privileges by causing an X client to be treated as trusted.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4752


Solution: 
    All OpenSSH users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-misc/openssh-4.7"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-02] OpenSSH: Security bypass");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenSSH: Security bypass');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-misc/openssh", unaffected: make_list("ge 4.7"), vulnerable: make_list("lt 4.7")
)) { security_warning(0); exit(0); }
